<?php

include 'services/session.php';

// Retrieve invoice_id from the URL
$invoice_id = isset($_GET['invoice_id']) ? $_GET['invoice_id'] : null;

// Now you can use $invoice_id in your code
?>

<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Trial Balance";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Trial Balance";
    include 'partials/menu.php'; ?>
            
            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                  <!-- Start Content-->
                  <div class="container-fluid">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body">
                                 
                                    <div class="panel-body">
                                        <div class="clearfix">
                                            <div class="float-start">
                                                <h3>Faida Accounting System</h3>
                                            </div>
                                            <div class="float-end">
                                                <h4>Invoice # <br>
                                                    <strong><?php echo $invoice_id; ?></strong>
                                                </h4>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-12">
    
                                                <div class="float-start mt-3">
                                                    <address>
                                                        <strong>Twitter, Inc.</strong><br>
                                                        795 Folsom Ave, Suite 600<br>
                                                        San Francisco, CA 94107<br>
                                                        <abbr title="Phone">P:</abbr> (123) 456-7890
                                                    </address>
                                                </div>
                                                <div class="float-end mt-3">
                                                    <p><strong>Order Date: </strong> Jan 17, 2016</p>
                                                    <p class="m-t-10"><strong>Order Status: </strong> <span class="label label-pink">Pending</span></p>
                                                    <p class="m-t-10"><strong>Order ID: </strong> #123456</p>
                                                </div>
                                            </div><!-- end col -->
                                        </div>
                                        <!-- end row -->
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="table-responsive">
                                                    <table class="table table-bordered mt-4">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Total</th>
                                                                <th>Total Debits</th>
                                                                <th>Total Credits</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr>
                                                                <td></td>
                                                                <td></td>
                                                                <!-- Placeholder for Total Debit -->
                                                                <td>Total Debit: <span id="totalDebit">$0.00</span></td>
                                                                <!-- Placeholder for Total Credit -->
                                                                <td>Total Credit: <span id="totalCredit">$0.00</span></td>
                                                            </tr>
                                                            <!-- Row for Subtotals under Total Debits and Total Credits -->
                                                            <tr>
                                                                <td></td>
                                                                <td></td>
                                                                <td>Sub-total Debit: <span id="subTotalDebit">2930.00</span></td>
                                                                <td>Sub-total Credit: <span id="subTotalCredit">2930.00</span></td>
                                                            </tr>
                                                            <!-- Add bottom border to the last row -->
                                                            <tr style="border-bottom: 2px solid #dee2e6;">
                                                                <td colspan="4"></td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-4">
                                            </div>    
                                            <div class="col-md-8">
                                                <div class="table-responsive">
                                                    <table class="table table-bordered">
                                                        <tbody>
                                                            <tr>
                                                                <td><b>Sub-total:</b></td>
                                                                <td class="text-end">2930.00</td>
                                                            </tr>
                                                            <tr>
                                                                <td><b>Total:</b></td>
                                                                <td class="text-end">USD 2930.00</td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>


                                        <hr>
                                        <div class="d-print-none">
                                            <div class="float-end">
                                                <a href="javascript:window.print()" class="btn btn-dark waves-effect waves-light"><i class="fa fa-print"></i></a>
                                            </div>
                                            <div class="d-print-none mt-4">
                                                <button class="btn btn-primary" id="generateTrialBalanceBtn">Generate Trial Balance</button>
                                            </div>

                                            <div class="clearfix"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                          
                        </div>

                    </div>
                    <!-- end row -->        
                    
                </div> <!-- container-fluid -->

                </div> <!-- content -->

                <?php include 'partials/footer.php'; ?>

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <?php include 'partials/right-sidebar.php'; ?>

        <?php include 'partials/footer-scripts.php'; ?>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
        <script>
            $(document).ready(function () {
                // Add an event listener to the button
                $('#generateTrialBalanceBtn').on('click', function () {
                    generateTrialBalance();
                });
            });
            
            // Your existing generateTrialBalance function goes here
            function generateTrialBalance() {
                // Make an AJAX request to fetch and update the trial balance
                $.ajax({
                    type: 'POST',
                    url: 'inc_trial_balance.php',
                    success: function (response) {
                        console.log('Trial Balance Response:', response);
                        updateTrialBalance(response);
                    },
                    error: function (error) {
                        console.error('Error fetching trial balance data:', error);
                    }
                });
            }
            
            // Your existing updateTrialBalance function goes here
            function updateTrialBalance(data) {
                console.log('Received data:', data);
            
                // Check if data is an object
                if (typeof data === 'object' && data !== null) {
                    // Check if totalDebit is present in the data object
                    if ('totalDebit' in data) {
                        $('#totalDebit').text('$' + (Number(data.totalDebit) || 0).toFixed(2));
                    } else {
                        console.error('totalDebit is undefined in the received data.');
                    }
            
                    // Similarly, check and update totalCredit
                    if ('totalCredit' in data) {
                        $('#totalCredit').text('$' + (Number(data.totalCredit) || 0).toFixed(2));
                    } else {
                        console.error('totalCredit is undefined in the received data.');
                    }
                } else {
                    console.error('Received data is not an object or is null.');
                }
            }



        </script>

    </body>
</html>